/*
 * Decompiled with CFR 0.152.
 */
package mpstpp;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import mpstpp.MpstppGlob;
import mpstpp.MpstppLoc;
import mpstpp.VersionProvider;
import picocli.CommandLine;

@CommandLine.Command(name="mpstpp", description={"MPST++ command-line tools"}, versionProvider=VersionProvider.class, mixinStandardHelpOptions=true)
public class Mpstpp {
    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine(new Mpstpp());
        commandLine.addSubcommand("glob", new MpstppGlob());
        commandLine.addSubcommand("loc", new MpstppLoc());
        List<CommandLine> parsed = null;
        try {
            parsed = commandLine.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (parsed.size() == 1) {
            CommandLine command = parsed.get(0);
            if (command.isVersionHelpRequested()) {
                command.printVersionHelp(System.out);
                return;
            }
            command.usage(System.out);
        } else {
            CommandLine command = parsed.get(1);
            if (command.isVersionHelpRequested()) {
                command.printVersionHelp(System.out);
                return;
            }
            if (command.isUsageHelpRequested()) {
                command.usage(System.out);
                return;
            }
            if (command.getCommand() instanceof MpstppGlob) {
                ((MpstppGlob)command.getCommand()).call();
            }
            if (command.getCommand() instanceof MpstppLoc) {
                ((MpstppLoc)command.getCommand()).call();
            }
        }
    }

    public static void write(String fileName, String s) {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(fileName));
            w.write(s);
            w.newLine();
            w.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }
}

