/*
 * Decompiled with CFR 0.152.
 */
package mpstpp;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mpstpp.Mpstpp;
import mpstpp.Util;
import mpstpp.VersionProvider;
import mpstpp.terms.Alpha;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.glob.Glob;
import mpstpp.terms.loc.Loc;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import picocli.CommandLine;

@CommandLine.Command(name="glob", description={"MPST++ command-line tools for global types"}, versionProvider=VersionProvider.class, mixinStandardHelpOptions=true)
public class MpstppGlob
implements Callable<Void> {
    @CommandLine.Option(names={"--parse"}, description={"Parse the global type."})
    private boolean parse;
    @CommandLine.Option(names={"--run"}, description={"Parse and run the global type."})
    private boolean run;
    @CommandLine.Option(names={"--check"}, description={"Parse the global type and check if it and its projections (if --project) are ok."})
    private boolean check;
    @CommandLine.Option(names={"--mcrl2"}, paramLabel="<equivalence>", arity="1", description={"Use only mCRL2 to check operational correspondence under the specified equivalence (e.g., 'none', 'bisim', 'branching-bisim', 'weak-bisim', 'weak-trace')."})
    private String mcrl2;
    @CommandLine.Option(names={"--project"}, paramLabel="<role>", arity="0..1", description={"Parse and project the global type onto the specified role, or onto all roles (if no role is specified)."})
    private String project;
    @CommandLine.Option(names={"--java"}, paramLabel="<packageName>", arity="1", description={"Generate Java APIs."})
    private String java;
    @CommandLine.Option(names={"--json"}, description={"Generate JSON specification."})
    private boolean json;
    @CommandLine.Option(names={"--times"}, description={"Print elapsed times."})
    private boolean times;
    @CommandLine.Option(names={"--parallel"}, description={"Use parallel processing wherever possible."})
    private boolean parallel;
    @CommandLine.Option(names={"--reps"}, paramLabel="<n>", arity="1", description={"Number of repetitions (default: 1)"})
    private int reps = 1;
    @CommandLine.Option(names={"--benchmark"}, paramLabel="<confidenceLevel>", arity="1", description={"Benchmark under the specified confidence level."})
    private float benchmark;
    @CommandLine.Option(names={"--out"}, description={"Output directory to write the global type and its projections to (ignored if --parse)"})
    private File out;
    @CommandLine.Parameters(index="0", description={"Global type (in single quotes or in a .glob file)"})
    private String in;

    public static void main(String[] args) {
        CommandLine.call(new MpstppGlob(), args);
    }

    @Override
    public Void call() {
        try {
            Object name = "g" + System.currentTimeMillis();
            if (this.in.endsWith(".glob")) {
                name = this.in.substring(this.in.lastIndexOf(File.separator) + 1, this.in.length() - 5);
            }
            if (this.in.endsWith(".scr")) {
                name = this.in.substring(this.in.lastIndexOf(File.separator) + 1, this.in.length() - 4);
            }
            StringBuilder fileNamePrefixBuilder = new StringBuilder();
            if (this.out != null) {
                fileNamePrefixBuilder.append(this.out.getPath()).append(File.separator);
            }
            fileNamePrefixBuilder.append((String)name);
            String fileNamePrefix = fileNamePrefixBuilder.toString();
            long parseTime = System.currentTimeMillis();
            Glob glob = Util.parseGlob(this.in);
            parseTime = System.currentTimeMillis() - parseTime;
            if (this.parse) {
                System.out.println(glob);
                return null;
            }
            if (this.run) {
                Consumer<Long> sleep = millis -> {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        System.out.print("");
                    }
                };
                Supplier<Reduction<Glob>> supplier = Util.runAsync(glob);
                System.out.println(glob);
                long time = System.currentTimeMillis();
                while (true) {
                    Reduction<Glob> r = supplier.get();
                    Alpha a = r.a;
                    Glob g$prime = (Glob)r.t$prime;
                    sleep.accept(500L - (System.currentTimeMillis() - time));
                    System.out.println(" ** " + a + " **");
                    if (a == Alpha.deadlock || a == Alpha.termination) break;
                    sleep.accept(500L);
                    System.out.println(g$prime);
                    time = System.currentTimeMillis();
                }
                return null;
            }
            SummaryStatistics stats = new SummaryStatistics();
            if (this.benchmark > 0.0f) {
                String b = ",mean,sd,min,max,ciw/2,(ciw/2)/mean,";
                System.out.println(b);
            }
            Glob globNotAlphaConverted = glob;
            while (stats.getN() < (long)this.reps) {
                long projectAndCheckTime = System.currentTimeMillis();
                long projectAndCheckNano = System.nanoTime();
                if (this.check && this.mcrl2 == null) {
                    boolean ok = Util.checkGlob(glob);
                    if ((double)this.benchmark < 0.1) {
                        System.out.println("Checks:");
                        System.out.println(" [" + (ok ? "X" : " ") + "] Global type" + (this.out == null ? ": " + glob : " (" + fileNamePrefix + ".glob)"));
                    }
                }
                if (this.check && this.mcrl2 != null) {
                    glob = (Glob)globNotAlphaConverted.alphaConvert();
                }
                Map<Object, Object> locs = this.project == null ? Collections.emptyMap() : (this.project.equals("") ? Util.projectOntoAll(glob) : Util.projectOntoOne(glob, new Role(this.project)));
                if (this.check && this.mcrl2 == null) {
                    Stream stream = this.parallel ? locs.entrySet().parallelStream() : locs.entrySet().stream();
                    stream.forEach(e -> {
                        Role r = (Role)e.getKey();
                        Loc l = (Loc)e.getValue();
                        boolean ok = Util.checkLoc(l);
                        if ((double)this.benchmark < 0.1) {
                            System.out.println(" [" + (ok ? "X" : " ") + "] Projection onto " + r + (this.out == null ? ": " + l : " (" + fileNamePrefix + "." + r + ".loc)"));
                        }
                    });
                }
                if (this.check && this.mcrl2 != null) {
                    String globFileNameWithoutExtension = fileNamePrefix + ".glob";
                    String locsFileNameWithoutExtension = fileNamePrefix + ".locs";
                    Process rmProcess = new ProcessBuilder("/bin/sh", "-c", "rm " + globFileNameWithoutExtension + ".mcrl2 " + globFileNameWithoutExtension + ".aut " + locsFileNameWithoutExtension + ".mcrl2 " + locsFileNameWithoutExtension + ".aut").start();
                    rmProcess.waitFor();
                    String string = Util.toMCRL2(glob, locs, glob);
                    Mpstpp.write(globFileNameWithoutExtension + ".mcrl2", string);
                    String globCommand = "mcrl22lps " + globFileNameWithoutExtension + ".mcrl2 | lps2lts /dev/stdin " + globFileNameWithoutExtension + ".aut";
                    Process globProcess = new ProcessBuilder("/bin/sh", "-c", globCommand).start();
                    globProcess.waitFor();
                    String globProcessOutput = new BufferedReader(new InputStreamReader(globProcess.getErrorStream())).readLine();
                    if (globProcessOutput != null && globProcessOutput.startsWith("[error]")) {
                        throw new Exception(globProcessOutput);
                    }
                    String locsMCRL2 = Util.toMCRL2(glob, locs, locs);
                    Mpstpp.write(locsFileNameWithoutExtension + ".mcrl2", locsMCRL2);
                    String locsCommand = "mcrl22lps " + locsFileNameWithoutExtension + ".mcrl2 | lps2lts /dev/stdin " + locsFileNameWithoutExtension + ".aut";
                    Process locsProcess = new ProcessBuilder("/bin/sh", "-c", locsCommand).start();
                    locsProcess.waitFor();
                    String locsProcessOutput = new BufferedReader(new InputStreamReader(locsProcess.getErrorStream())).readLine();
                    if (locsProcessOutput != null && locsProcessOutput.startsWith("[error]")) {
                        throw new Exception(locsProcessOutput);
                    }
                    String compCommand = "ltscompare --equivalence=" + this.mcrl2 + " " + globFileNameWithoutExtension + ".aut " + locsFileNameWithoutExtension + ".aut";
                    Process compProcess = new ProcessBuilder("/bin/sh", "-c", compCommand).start();
                    compProcess.waitFor();
                    String compProcessOutput = new BufferedReader(new InputStreamReader(compProcess.getErrorStream())).readLine();
                    if (compProcessOutput != null && compProcessOutput.startsWith("[error]")) {
                        throw new Exception(compProcessOutput);
                    }
                    if ((double)this.benchmark < 0.1) {
                        System.out.println(compProcessOutput);
                    }
                }
                String outJava = null;
                if (this.java != null) {
                    outJava = Util.generateJava(this.java, (String)name, locs);
                    if (this.out == null) {
                        System.out.println();
                        System.out.println(outJava);
                    }
                }
                String outJson = null;
                if (this.json) {
                    outJson = Util.generateJson(locs);
                    if (this.out == null) {
                        System.out.println();
                        System.out.println(outJson);
                    }
                }
                projectAndCheckNano = System.nanoTime() - projectAndCheckNano;
                projectAndCheckTime = System.currentTimeMillis() - projectAndCheckTime;
                stats.addValue(projectAndCheckNano);
                if (this.times) {
                    System.out.println("Times elapsed:");
                    System.out.println(" * Parse:               " + parseTime + "ms");
                    System.out.println(" * Check-project-check: " + projectAndCheckTime + "ms");
                }
                if (this.out != null && this.out.isDirectory() && this.out.canWrite()) {
                    Mpstpp.write(fileNamePrefix + ".glob", glob.toString());
                    for (Map.Entry entry : locs.entrySet()) {
                        Role r = (Role)entry.getKey();
                        Loc l = (Loc)entry.getValue();
                        Mpstpp.write(fileNamePrefix + "." + r + ".loc", l.toString());
                    }
                    if (outJava != null) {
                        Mpstpp.write(fileNamePrefix + ".java", outJava);
                    }
                    if (outJson != null) {
                        Mpstpp.write(fileNamePrefix + ".json", outJson);
                    }
                }
                if (!(this.benchmark > 0.0f)) continue;
                Function<Double, String> f = d -> String.format(Locale.US, "%.2f", d);
                StringBuilder stringBuilder = new StringBuilder().append(projectAndCheckNano).append(",").append(f.apply(stats.getMean())).append(",").append(f.apply(stats.getStandardDeviation())).append(",").append(stats.getMin()).append(",").append(stats.getMax()).append(",");
                if (stats.getN() > 1L) {
                    float confidenceLevel = this.benchmark;
                    TDistribution distribution = new TDistribution(stats.getN() - 1L);
                    double criticalValue = distribution.inverseCumulativeProbability(1.0f - (1.0f - confidenceLevel) / 2.0f);
                    double epsilon = criticalValue * stats.getStandardDeviation() / Math.sqrt(stats.getN());
                    stringBuilder.append(f.apply(epsilon)).append(",").append(epsilon / stats.getMean());
                    System.out.println(stringBuilder.toString());
                    if (!(epsilon < stats.getMean() * 0.05)) continue;
                    System.out.println();
                    System.out.println("Converged (confidence level: " + confidenceLevel + ") after measurement " + stats.getN());
                    System.err.println(this.in + ", " + (String)(this.mcrl2 == null ? "no mcrl2" : "mcrl2 (" + this.mcrl2 + ")") + ", converged (confidence level: " + confidenceLevel + ") after measurement " + stats.getN() + " -> " + stringBuilder.toString());
                    break;
                }
                stringBuilder.append(",");
                System.out.println(stringBuilder.toString());
            }
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            System.exit(1);
        }
        return null;
    }
}

