/*
 * Decompiled with CFR 0.152.
 */
package mpstpp;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mpstpp.Mpstpp;
import mpstpp.Util;
import mpstpp.VersionProvider;
import mpstpp.terms.Alpha;
import mpstpp.terms.Reduction;
import mpstpp.terms.loc.Loc;
import picocli.CommandLine;

@CommandLine.Command(name="loc", description={"MPST++ command-line tools for local types"}, versionProvider=VersionProvider.class, mixinStandardHelpOptions=true)
public class MpstppLoc
implements Callable<Void> {
    @CommandLine.Option(names={"--parse"}, description={"Parse the local type."})
    private boolean parse;
    @CommandLine.Option(names={"--run"}, description={"Parse and run the local type."})
    private boolean run;
    @CommandLine.Option(names={"--check"}, description={"Parse the local type and check if it is ok."})
    private boolean check;
    @CommandLine.Option(names={"--times"}, description={"Print elapsed times."})
    private boolean times;
    @CommandLine.Option(names={"--out"}, description={"Output directory to write the local type to (ignored if --parse)"})
    private File out;
    @CommandLine.Parameters(index="0", description={"Local type (in single quotes or in a .loc file)"})
    private String in;

    public static void main(String[] args) {
        CommandLine.call(new MpstppLoc(), args);
    }

    @Override
    public Void call() {
        try {
            Object name = "l" + System.currentTimeMillis();
            if (this.in.endsWith(".loc")) {
                name = this.in.substring(this.in.lastIndexOf(File.separator) + 1, this.in.length() - 4);
            }
            StringBuilder fileNamePrefixBuilder = new StringBuilder();
            if (this.out != null) {
                fileNamePrefixBuilder.append(this.out.getPath()).append(File.separator);
            }
            fileNamePrefixBuilder.append((String)name);
            String fileNamePrefix = fileNamePrefixBuilder.toString();
            long parseTime = System.currentTimeMillis();
            Loc loc = Util.parseLoc(this.in);
            parseTime = System.currentTimeMillis() - parseTime;
            if (this.parse) {
                System.out.println(loc);
                return null;
            }
            if (this.run) {
                Consumer<Long> sleep = millis -> {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        System.out.print("");
                    }
                };
                Supplier<Reduction<Loc>> supplier = Util.runAsync(loc);
                System.out.println(loc);
                long time = System.currentTimeMillis();
                while (true) {
                    Reduction<Loc> r = supplier.get();
                    Alpha a = r.a;
                    Loc l$prime = (Loc)r.t$prime;
                    sleep.accept(500L - (System.currentTimeMillis() - time));
                    System.out.println(" ** " + a + " **");
                    if (a == Alpha.deadlock || a == Alpha.termination) break;
                    sleep.accept(500L);
                    System.out.println(l$prime);
                    time = System.currentTimeMillis();
                }
                return null;
            }
            long checkTime = System.currentTimeMillis();
            if (this.check) {
                boolean ok = Util.checkLoc(loc);
                System.out.println("Check:");
                System.out.println(" [" + (ok ? "X" : " ") + "] Local type" + (this.out == null ? ": " + loc : "(" + fileNamePrefix + ".loc)"));
            }
            checkTime = System.currentTimeMillis() - checkTime;
            if (this.times) {
                System.out.println("Times elapsed:");
                System.out.println(" * Parse: " + parseTime + "ms");
                System.out.println(" * Check: " + checkTime + "ms");
            }
            if (this.out != null && this.out.isDirectory() && this.out.canWrite()) {
                Mpstpp.write(fileNamePrefix + ".loc", loc.toString());
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        return null;
    }
}

