/*
 * Decompiled with CFR 0.152.
 */
package mpstpp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mpstpp.generator.java.Session;
import mpstpp.generator.json.Protocol;
import mpstpp.parser.ErrorListener;
import mpstpp.parser.GlobVisitor;
import mpstpp.parser.LocVisitor;
import mpstpp.parser.ScrVisitor;
import mpstpp.parser.gen.GlobLexer;
import mpstpp.parser.gen.GlobParser;
import mpstpp.parser.gen.LocLexer;
import mpstpp.parser.gen.LocParser;
import mpstpp.parser.gen.ScrLexer;
import mpstpp.parser.gen.ScrParser;
import mpstpp.terms.Act;
import mpstpp.terms.Alpha;
import mpstpp.terms.Axiom;
import mpstpp.terms.Mu;
import mpstpp.terms.Par;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Term;
import mpstpp.terms.Terms;
import mpstpp.terms.Var;
import mpstpp.terms.glob.Glob;
import mpstpp.terms.glob.act.Comm;
import mpstpp.terms.loc.Loc;
import mpstpp.terms.loc.act.Recv;
import mpstpp.terms.loc.act.Send;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;

public class Util {
    public static boolean checkGlob(Glob g) {
        return g.isGuarded() && g.isClosed() && g.hasNoOccurrencesOfOne() && (g.isDeterministic() || Terms.isDeterministicCoinductively(g));
    }

    public static boolean checkLoc(Loc l) {
        Mu mu;
        if (l.hasNoOccurrencesOfTau()) {
            return true;
        }
        if (l instanceof Mu && (mu = (Mu)((Object)l)).isSpecial()) {
            return true;
        }
        if (l instanceof Par) {
            for (Loc l1 : l.getSubterms()) {
                for (Loc l2 : l.getSubterms()) {
                    if (l1.equals(l2)) continue;
                    for (Act a1 : l1.getActs()) {
                        for (Act a2 : l2.getActs()) {
                            if (a1 instanceof Send && a2 instanceof Recv && Objects.equals(((Send)a1).p, ((Recv)a2).p) && Objects.equals(((Send)a1).q, ((Recv)a2).q) && Objects.equals(((Send)a1).l, ((Recv)a2).l) && Objects.equals(((Send)a1).y, ((Recv)a2).y)) {
                                return false;
                            }
                            if (!(a1 instanceof Recv) || !(a2 instanceof Send) || !Objects.equals(((Recv)a1).p, ((Send)a2).p) || !Objects.equals(((Recv)a1).q, ((Send)a2).q) || !Objects.equals(((Recv)a1).l, ((Send)a2).l) || !Objects.equals(((Recv)a1).y, ((Send)a2).y)) continue;
                            return false;
                        }
                    }
                }
                if (Util.checkLoc(l1)) continue;
                return false;
            }
            return true;
        }
        return Terms.isHeartCoinductively(l) && Terms.isDiamondCoinductively(l);
    }

    public static String generateJava(String packageName, String className, Map<Role, Loc> locs) {
        LinkedHashMap<Role, Loc> m = new LinkedHashMap<Role, Loc>();
        for (Map.Entry<Role, Loc> e : locs.entrySet()) {
            Role r = e.getKey();
            Loc l = e.getValue();
            Set equals = l.getEqualsUpTo(Axiom.values());
            if (!equals.isEmpty()) {
                Loc l1 = (Loc)equals.iterator().next();
                m.put(r, (Loc)l1.eliminateTaus());
                continue;
            }
            throw new IllegalArgumentException();
        }
        return Session.generate(packageName, className, m);
    }

    public static String generateJson(Map<Role, Loc> locs) {
        LinkedHashMap<Role, Loc> m = new LinkedHashMap<Role, Loc>();
        for (Map.Entry<Role, Loc> e : locs.entrySet()) {
            Role r = e.getKey();
            Loc l = e.getValue();
            Set equals = l.getEqualsUpTo(Axiom.values());
            if (!equals.isEmpty()) {
                Loc l1 = (Loc)equals.iterator().next();
                m.put(r, (Loc)l1.eliminateTaus());
                continue;
            }
            throw new IllegalArgumentException();
        }
        return Protocol.generate(m);
    }

    public static Glob parseGlob(String s) throws IOException {
        if (s.endsWith(".scr")) {
            return Util.parseScr(s);
        }
        CharStream stream = CharStreams.fromString(s);
        if (s.endsWith(".glob")) {
            stream = CharStreams.fromFileName(s);
        }
        GlobLexer lexer = new GlobLexer(stream);
        lexer.addErrorListener(new ErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        GlobParser parser = new GlobParser(tokens);
        parser.addErrorListener(new ErrorListener());
        return (Glob)((Glob)new GlobVisitor().visit(parser.glob())).simplify();
    }

    public static Glob parseGlobOrThrowUnchecked(String s) {
        try {
            return Util.parseGlob(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Loc parseLoc(String s) throws IOException {
        CharStream stream = CharStreams.fromString(s);
        if (s.endsWith(".loc")) {
            stream = CharStreams.fromFileName(s);
        }
        LocLexer lexer = new LocLexer(stream);
        lexer.addErrorListener(new ErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        LocParser parser = new LocParser(tokens);
        parser.addErrorListener(new ErrorListener());
        return (Loc)((Loc)new LocVisitor().visit(parser.loc())).simplify();
    }

    public static Loc parseLocOrThrowUnchecked(String s) {
        try {
            return Util.parseLoc(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Glob parseScr(String s) throws IOException {
        CharStream stream = CharStreams.fromString(s);
        if (s.endsWith(".scr")) {
            stream = CharStreams.fromFileName(s);
        }
        ScrLexer lexer = new ScrLexer(stream);
        lexer.addErrorListener(new ErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ScrParser parser = new ScrParser(tokens);
        parser.addErrorListener(new ErrorListener());
        return (Glob)((Glob)new ScrVisitor().visit(parser.scr())).simplify();
    }

    public static Map<Role, Loc> projectOntoOne(Glob g, Role r) {
        LinkedHashMap<Role, Loc> m = new LinkedHashMap<Role, Loc>();
        m.put(r, g.project(r));
        return m;
    }

    public static Map<Role, Loc> projectOntoAll(Glob g) {
        LinkedHashMap<Role, Loc> m = new LinkedHashMap<Role, Loc>();
        for (Role r : g.getRoles()) {
            m.put(r, g.project(r));
        }
        return m;
    }

    public static <T extends Term<T>> Supplier<Reduction<T>> runAsync(T t) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
        Supplier<Reduction<T>> taker = () -> {
            while (true) {
                try {
                    return (Reduction)queue.take();
                }
                catch (InterruptedException e) {
                    System.out.print("");
                    continue;
                }
                break;
            }
        };
        Consumer<Reduction> putter = r -> {
            while (true) {
                try {
                    queue.put(r);
                }
                catch (InterruptedException e) {
                    System.out.print("");
                    continue;
                }
                break;
            }
        };
        Random random = new Random();
        Function<Set, Reduction> selector = reductions -> {
            int i = 0;
            int n = random.nextInt(reductions.size());
            for (Reduction r : reductions) {
                if (i++ != n) continue;
                return r;
            }
            throw new IllegalArgumentException();
        };
        new Thread(() -> {
            Term t$prime = t;
            while (!t$prime.isFinal()) {
                Reduction<Term> r;
                Set reductions = t$prime.getReductions();
                if (reductions.isEmpty()) {
                    r = new Reduction<Term>(t$prime, Alpha.deadlock, t$prime);
                    putter.accept(r);
                    return;
                }
                r = (Reduction<Term>)selector.apply(reductions);
                putter.accept(r);
                t$prime = r.t$prime;
            }
            Reduction<Term> r = new Reduction<Term>(t$prime, Alpha.termination, t$prime);
            putter.accept(r);
        }).start();
        return taker;
    }

    public static String toMCRL2(Glob glob, Map<Role, Loc> locs, Object init) {
        Recv recv;
        Send send;
        StringBuilder b = new StringBuilder();
        ArrayList<Comm> gActs = new ArrayList<Comm>();
        ArrayList<Act> lActs = new ArrayList<Act>();
        b.append("act");
        for (Act act : glob.getActs()) {
            Comm comm = (Comm)act.cast();
            gActs.add(comm);
            b.append(System.lineSeparator()).append("  ").append(comm.toMCRL2("")).append(", ");
            if (locs != init) continue;
            send = (Send)comm.project(comm.p);
            recv = (Recv)comm.project(comm.q);
            lActs.add(send);
            lActs.add(recv);
            b.append(send.toMCRL2("")).append(", ").append(recv.toMCRL2("")).append(", ");
        }
        b.delete(b.length() - 2, b.length()).append(" ;");
        b.append(System.lineSeparator()).append("proc");
        if (glob == init) {
            String procPrefix = "Glob";
            b.append(System.lineSeparator()).append("  ").append(procPrefix).append(" = ").append(glob.toMCRL2(procPrefix)).append(" ;");
            for (Mu mu : glob.getMus()) {
                Mu mu2 = (Mu)mu.cast();
                b.append(System.lineSeparator()).append("  ").append(procPrefix).append("_").append(mu2.vName).append(" = ").append(mu2.tBody.toMCRL2(procPrefix)).append(" ;");
            }
        }
        if (locs == init) {
            for (Map.Entry entry : locs.entrySet()) {
                Role role = (Role)entry.getKey();
                Loc loc = (Loc)entry.getValue();
                Set s = loc.getEqualsUpTo(Axiom.values());
                if (s.size() == 1) {
                    loc = (Loc)s.iterator().next();
                }
                String procPrefix = "Loc_" + role;
                b.append(System.lineSeparator()).append("  ").append(procPrefix).append(" = ").append(loc.toMCRL2(procPrefix)).append(" ;");
                for (Mu l : loc.getMus()) {
                    Mu mu = (Mu)l.cast();
                    b.append(System.lineSeparator()).append("  ").append(procPrefix).append("_").append(mu.vName).append(" = ").append(mu.tBody instanceof Var ? "tau . " : "").append(mu.tBody.toMCRL2(procPrefix)).append(" ;");
                }
            }
        }
        b.append(System.lineSeparator()).append("init");
        if (glob == init) {
            b.append(System.lineSeparator()).append("  allow(");
            b.append(System.lineSeparator()).append("    { ");
            for (Term term : gActs) {
                b.append(term.toMCRL2("")).append(", ");
            }
            b.delete(b.length() - 2, b.length()).append(" },");
            b.append(System.lineSeparator()).append("  Glob");
            b.append(System.lineSeparator()).append("  ) ;");
        }
        if (locs == init) {
            b.append(System.lineSeparator()).append("  allow(");
            b.append(System.lineSeparator()).append("    { ");
            for (Term term : gActs) {
                b.append(term.toMCRL2("")).append(", ");
            }
            b.delete(b.length() - 2, b.length()).append(" },");
            b.append(System.lineSeparator()).append("    comm(");
            b.append(System.lineSeparator()).append("      { ");
            for (Term term : gActs) {
                Comm comm = (Comm)term.cast();
                send = (Send)comm.project(comm.p);
                recv = (Recv)comm.project(comm.q);
                b.append(send.toMCRL2("")).append("|").append(recv.toMCRL2("")).append(" -> ").append(comm.toMCRL2("")).append(", ");
            }
            b.delete(b.length() - 2, b.length()).append(" },");
            for (Map.Entry entry : locs.entrySet()) {
                Role role = (Role)entry.getKey();
                String procPrefix = "Loc_" + role;
                b.append(System.lineSeparator()).append("      ").append(procPrefix);
                b.append(" ||");
            }
            b.delete(b.length() - 3, b.length());
            b.append(System.lineSeparator()).append("  ) ) ;");
        }
        return b.toString();
    }
}

