/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.generator.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mpstpp.generator.java.API;
import mpstpp.generator.java.Session;
import mpstpp.generator.java.act.Recv;
import mpstpp.terms.Role;

public class AltRecv
implements API {
    private final List<Recv> recvs = new ArrayList<Recv>();
    private final List<API> continuations = new ArrayList<API>();

    AltRecv(Recv recv, API continuation) {
        this.recvs.add(recv);
        this.continuations.add(continuation);
    }

    AltRecv(List<AltRecv> altSends) {
        for (AltRecv l : altSends) {
            this.recvs.addAll(l.recvs);
            this.continuations.addAll(l.continuations);
        }
    }

    @Override
    public String generate(Role r, API.SerialNumbers serialNumbers, Map<String, API> mus, Set<API> done) {
        int i;
        API continuation;
        Recv recv2;
        int i2;
        if (done.contains(this)) {
            return "";
        }
        done.add(this);
        StringBuilder b = new StringBuilder().append("public interface ").append(this.getInterfaceName(r, serialNumbers)).append(" { ");
        b.append(System.lineSeparator());
        b.append("void recv(");
        for (i2 = 0; i2 < this.recvs.size(); ++i2) {
            recv2 = this.recvs.get(i2);
            continuation = this.continuations.get(i2);
            b.append("RecvContinuation<").append(recv2.recv.y.isEmpty() ? "Object" : recv2.recv.y).append(", ").append(continuation.getInterfaceName(r, serialNumbers)).append("> c").append(i2).append(", ");
        }
        b.delete(b.length() - 2, b.length()).append(");");
        b.append(System.lineSeparator());
        b.append("}");
        b.append(System.lineSeparator());
        b.append("private class ").append(this.getInterfaceName(r, serialNumbers)).append("$impl extends State implements ").append(this.getInterfaceName(r, serialNumbers)).append(" { ");
        b.append(System.lineSeparator());
        b.append("private ").append(this.getInterfaceName(r, serialNumbers)).append("$impl(java.util.Map<String, Object> continuations) { super(").append(r).append(".resources, continuations); }");
        b.append(System.lineSeparator());
        b.append("public void recv(");
        for (i2 = 0; i2 < this.recvs.size(); ++i2) {
            recv2 = this.recvs.get(i2);
            continuation = this.continuations.get(i2);
            b.append("RecvContinuation<").append(recv2.recv.y.isEmpty() ? "Object" : recv2.recv.y).append(", ").append(continuation.getInterfaceName(r, serialNumbers)).append("> c").append(i2).append(", ");
        }
        b.delete(b.length() - 2, b.length()).append(") {");
        b.append(System.lineSeparator());
        b.append("use(() ->  {");
        b.append("var message = _recv(").append(r).append(".recvMonitor, ");
        for (Recv recv2 : this.recvs) {
            b.append(Session.toBufferName(recv2.recv.p, recv2.recv.q)).append(", ");
        }
        b.delete(b.length() - 2, b.length()).append("); ");
        for (i = 0; i < this.recvs.size(); ++i) {
            recv2 = this.recvs.get(i);
            continuation = this.continuations.get(i);
            b.append(System.lineSeparator());
            b.append("if (message.p.equals(\"").append(recv2.recv.p).append("\") && message.lab.equals(\"").append(recv2.recv.l).append("\") && message.type.equals(\"").append(recv2.recv.y.isEmpty() ? "Object" : recv2.recv.y).append("\")) {");
            b.append(System.lineSeparator());
            b.append("c").append(i).append(".run((").append(recv2.recv.y.isEmpty() ? "Object" : recv2.recv.y).append(") message.payl, new ").append(continuation.getInterfaceName(r, serialNumbers)).append("$impl(continuations));");
            b.append(System.lineSeparator());
            b.append("}");
        }
        b.append(System.lineSeparator());
        b.append("});");
        b.append(System.lineSeparator());
        b.append("}");
        b.append(System.lineSeparator());
        b.append("}");
        for (i = 0; i < this.recvs.size(); ++i) {
            API continuation2 = this.continuations.get(i);
            b.append(System.lineSeparator());
            b.append(continuation2.generate(r, serialNumbers, mus, done));
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AltRecv altRecv = (AltRecv)o;
        return Objects.equals(this.recvs, altRecv.recvs) && Objects.equals(this.continuations, altRecv.continuations);
    }

    public int hashCode() {
        return Objects.hash(this.recvs, this.continuations);
    }
}

