/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.generator.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mpstpp.generator.java.API;
import mpstpp.generator.java.Session;
import mpstpp.generator.java.act.Send;
import mpstpp.terms.Role;

public class AltSend
implements API {
    private final List<Send> sends = new ArrayList<Send>();
    private final List<API> continuations = new ArrayList<API>();

    AltSend(Send send, API continuation) {
        this.sends.add(send);
        this.continuations.add(continuation);
    }

    AltSend(List<AltSend> altSends) {
        for (AltSend l : altSends) {
            this.sends.addAll(l.sends);
            this.continuations.addAll(l.continuations);
        }
    }

    @Override
    public String generate(Role r, API.SerialNumbers serialNumbers, Map<String, API> mus, Set<API> done) {
        API continuation;
        Send send;
        int i;
        if (done.contains(this)) {
            return "";
        }
        done.add(this);
        StringBuilder b = new StringBuilder();
        b.append("public interface ").append(this.getInterfaceName(r, serialNumbers)).append(" { ");
        for (i = 0; i < this.sends.size(); ++i) {
            send = this.sends.get(i);
            continuation = this.continuations.get(i);
            b.append(System.lineSeparator());
            b.append("void ").append(send.toMethodName()).append("(").append(send.send.y.isEmpty() ? "Object" : send.send.y).append(" payl, ").append("SendContinuation<").append(continuation.getInterfaceName(r, serialNumbers)).append("> c);");
        }
        b.append(System.lineSeparator());
        b.append("}");
        b.append(System.lineSeparator());
        b.append("private class ").append(this.getInterfaceName(r, serialNumbers)).append("$impl extends State implements ").append(this.getInterfaceName(r, serialNumbers)).append(" { ");
        b.append(System.lineSeparator());
        b.append("private ").append(this.getInterfaceName(r, serialNumbers)).append("$impl(java.util.Map<String, Object> continuations) { super(").append(r).append(".resources, continuations); }");
        for (i = 0; i < this.sends.size(); ++i) {
            send = this.sends.get(i);
            continuation = this.continuations.get(i);
            b.append(System.lineSeparator());
            b.append("public void ").append(send.toMethodName()).append("(").append(send.send.y.isEmpty() ? "Object" : send.send.y).append(" payl, ").append("SendContinuation<").append(continuation.getInterfaceName(r, serialNumbers)).append("> c) {");
            b.append(System.lineSeparator());
            b.append("use(() ->  {");
            b.append("_send(").append(send.send.p).append(".sendMonitor, ").append(send.send.q).append(".recvMonitor, ").append(Session.toBufferName(send.send.p, send.send.q)).append(", new Message(\"").append(send.send.p).append("\", \"").append(send.send.q).append("\", \"").append(send.send.l).append("\", \"").append(send.send.y.isEmpty() ? "Object" : send.send.y).append("\", payl)); ");
            b.append("c.run(new ").append(continuation.getInterfaceName(r, serialNumbers)).append("$impl(continuations)); });");
            b.append(System.lineSeparator());
            b.append("}");
        }
        b.append("}");
        for (API continuation2 : this.continuations) {
            b.append(System.lineSeparator());
            b.append(continuation2.generate(r, serialNumbers, mus, done));
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AltSend altSend = (AltSend)o;
        return Objects.equals(this.sends, altSend.sends) && Objects.equals(this.continuations, altSend.continuations);
    }

    public int hashCode() {
        return Objects.hash(this.sends, this.continuations);
    }
}

