/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.generator.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import mpstpp.generator.java.API;
import mpstpp.terms.Role;
import mpstpp.terms.loc.Loc;

public class Session {
    private static final String stuff = "    public static void delay(long millis) {\n        var deadline = System.currentTimeMillis() + millis;\n        while (System.currentTimeMillis() < deadline) {\n            try {\n                Thread.sleep(millis);\n            } catch (InterruptedException e) {\n            }\n        }\n    }\n    public interface Continuation<S> {\n        void run(S s);\n    }\n    public interface SendContinuation<S> {\n        void run(S s);\n    }\n    public interface RecvContinuation<T, S> {\n        void run(T payl, S s);\n    }\n    private class Message {\n        private final String p;\n        private final String q;\n        private final String lab;\n        private final String type;\n        private final Object payl;\n        public Message(String p, String q, String lab, String type, Object payl) {\n            this.p = p;\n            this.q = q;\n            this.lab = lab;\n            this.type = type;\n            this.payl = payl;\n        }\n    }\n    private class LinearResource {\n        private final AtomicBoolean used = new AtomicBoolean(false);\n        private final Set<LinearResource> resources;\n        protected LinearResource(Set<LinearResource> resources) {\n            this.resources = resources;\n            this.resources.add(this);\n        }\n        protected void use(Runnable r) {\n            if (used.getAndSet(true)) {\n                throw new IllegalStateException(\"linearity violation\");\n            } else {\n                resources.remove(this);\n                r.run();\n            }\n        }\n    }\n    private class State extends LinearResource {\n        protected final java.util.Map<String, Object> continuations;\n        public State(Set<LinearResource> resources, java.util.Map<String, Object> continuations) {\n            super(resources);\n            this.continuations = continuations;\n        }\n    }\n    private class Individual {\n        private final Set<LinearResource> resources = ConcurrentHashMap.newKeySet();\n        private final Set<Runnable> runnables = ConcurrentHashMap.newKeySet();\n        private final Object sendMonitor = new Object();\n        private final Object recvMonitor = new Object();\n        private void fork(Runnable r) {\n            new Thread(() -> {\n                runnables.add(r);\n                r.run();\n                runnables.remove(r);\n                if (runnables.isEmpty() && !resources.isEmpty()) {\n                    throw new RuntimeException(\"premature termination\");\n                }\n            }).start();\n        }\n        private void forkIfNeeded(Runnable r) {\n            if (Thread.currentThread().getStackTrace().length > 128) {\n                fork(r);\n            } else {\n                r.run();\n            }\n        }\n    }\n    private class Buffer {\n        private volatile Message cell;\n    }\n    private void _send(Object sender, Object receiver, Buffer buffer, Message message) {\n        synchronized (sender) {\n            synchronized (receiver) {\n                buffer.cell = message;\n                receiver.notifyAll();\n            }\n            synchronized (buffer) {\n                while (buffer.cell != null) {\n                    try {\n                        buffer.wait();\n                    } catch (InterruptedException e) {\n                    }\n                }\n            }\n        }\n    }\n    private Message _recv(Object receiver, Buffer... buffers) {\n        synchronized (receiver) {\n            while (true) {\n                for (Buffer buffer : buffers) {\n                    if (buffer.cell != null) {\n                        var message = buffer.cell;\n                        buffer.cell = null;\n                        synchronized (buffer) {\n                            buffer.notifyAll();\n                        }\n                        return message;\n                    }\n                }\n                try {\n                    receiver.wait();\n                } catch (InterruptedException e) {\n                }\n            }\n        }\n    }";

    static String toBufferName(Role r1, Role r2) {
        return "buffer_" + r1 + "_" + r2;
    }

    public static String generate(String packageName, String className, Map<Role, Loc> locs) {
        API.SerialNumbers serialNumbers;
        API api;
        Role r;
        LinkedHashMap<Role, API> apis = new LinkedHashMap<Role, API>();
        LinkedHashMap<Role, API.SerialNumbers> serialNumberss = new LinkedHashMap<Role, API.SerialNumbers>();
        for (Map.Entry<Role, Loc> e : locs.entrySet()) {
            Role role = e.getKey();
            Loc l = e.getValue();
            apis.put(role, API.newAPI(l));
            serialNumberss.put(role, new API.SerialNumbers());
        }
        StringBuilder b = new StringBuilder();
        b.append("package ").append(packageName).append(";");
        b.append(System.lineSeparator());
        b.append("import java.util.*;");
        b.append(System.lineSeparator());
        b.append("import java.util.concurrent.*;");
        b.append(System.lineSeparator());
        b.append("import java.util.concurrent.atomic.*;");
        b.append(System.lineSeparator());
        b.append("public class ").append(className).append(" {");
        b.append(System.lineSeparator());
        b.append(stuff);
        b.append(System.lineSeparator());
        for (Role role : locs.keySet()) {
            for (Role r2 : locs.keySet()) {
                if (role.equals(r2)) continue;
                b.append(System.lineSeparator());
                b.append("private final Buffer ").append(Session.toBufferName(role, r2)).append(" = new Buffer();");
            }
        }
        b.append(System.lineSeparator());
        b.append(System.lineSeparator());
        b.append("private final AtomicBoolean runnable = new AtomicBoolean(true);");
        b.append(System.lineSeparator());
        b.append("public void run(");
        for (Map.Entry entry : locs.entrySet()) {
            r = (Role)entry.getKey();
            b.append(r).append(" ").append(r.toString().toLowerCase()).append(", ");
        }
        b.delete(b.length() - 2, b.length()).append(") {");
        b.append(System.lineSeparator());
        b.append("if (runnable.getAndSet(false)) {");
        for (Map.Entry entry : locs.entrySet()) {
            r = (Role)entry.getKey();
            api = (API)apis.get(r);
            serialNumbers = (API.SerialNumbers)serialNumberss.get(r);
            b.append(System.lineSeparator());
            b.append(r).append(".fork(() -> ").append(r.toString().toLowerCase()).append(".run(new ").append(api.getInterfaceName(r, serialNumbers)).append("$impl(new HashMap())));");
        }
        b.append(System.lineSeparator());
        b.append("} else { throw new IllegalStateException(\"linearity violation\"); }");
        b.append(System.lineSeparator());
        b.append("}");
        b.append(System.lineSeparator());
        for (Map.Entry entry : locs.entrySet()) {
            r = (Role)entry.getKey();
            api = (API)apis.get(r);
            serialNumbers = (API.SerialNumbers)serialNumberss.get(r);
            b.append(System.lineSeparator());
            b.append("private final Individual ").append(r).append(" = new Individual();");
            b.append(System.lineSeparator());
            b.append("public interface ").append(r).append(" extends Continuation<").append(api.getInterfaceName(r, serialNumbers)).append("> {}");
            b.append(System.lineSeparator());
            b.append(api.generate(r, serialNumbers, new HashMap<String, API>(), new HashSet<API>()));
        }
        b.append("}");
        return b.toString();
    }
}

