/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.generator.json;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import mpstpp.terms.Alpha;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Term;
import mpstpp.terms.loc.Loc;
import mpstpp.terms.loc.act.Recv;
import mpstpp.terms.loc.act.Send;

public class Protocol {
    public static <T extends Term<T>> boolean areBisimilar(T t1, T t2) {
        ArrayList todo = new ArrayList();
        HashSet<Pair> done = new HashSet<Pair>();
        todo.add(new Pair<T>(t1, t2));
        while (!todo.isEmpty()) {
            boolean isSimulated;
            Pair p = (Pair)todo.remove(0);
            if (done.contains(p)) continue;
            done.add(p);
            for (Reduction<T> r1 : p.t1.getReductions()) {
                isSimulated = false;
                for (Reduction<T> r2 : p.t2.getReductions()) {
                    if (!r1.a.equals(r2.a)) continue;
                    isSimulated = true;
                    todo.add(new Pair(r1.t$prime, r2.t$prime));
                }
                if (isSimulated) continue;
                return false;
            }
            for (Reduction<T> r2 : p.t2.getReductions()) {
                isSimulated = false;
                for (Reduction<T> r1 : p.t1.getReductions()) {
                    if (!r1.a.equals(r2.a)) continue;
                    isSimulated = true;
                    todo.add(new Pair(r1.t$prime, r2.t$prime));
                }
                if (isSimulated) continue;
                return false;
            }
        }
        return true;
    }

    public static String generate(Map<Role, Loc> locs) {
        Function<JsonStructure, String> f = json -> {
            StringWriter w = new StringWriter();
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            Json.createWriterFactory(config).createWriter(w).write((JsonStructure)json);
            return w.toString();
        };
        JsonObjectBuilder json2 = Json.createObjectBuilder();
        JsonArrayBuilder rolesBuilder = Json.createArrayBuilder();
        for (Role r : locs.keySet()) {
            rolesBuilder.add(r.toString());
        }
        json2.add("roles", rolesBuilder);
        JsonArrayBuilder protocolBuilder = Json.createArrayBuilder();
        for (Map.Entry<Role, Loc> e : locs.entrySet()) {
            Role r = e.getKey();
            Loc l = e.getValue();
            JsonObjectBuilder b = Json.createObjectBuilder();
            b.add("role", r.toString());
            JsonArrayBuilder statesBuilder = Json.createArrayBuilder();
            int nextId = 1;
            HashMap<Loc, Integer> ids = new HashMap<Loc, Integer>();
            ids.put(l, nextId++);
            ArrayList<Loc> todo = new ArrayList<Loc>(Collections.singleton(l));
            while (!todo.isEmpty()) {
                JsonObjectBuilder stateBuilder = Json.createObjectBuilder();
                Loc l$prime = todo.remove(0);
                Set l$primeReductions = l$prime.getReductions();
                Integer l$primeId = (Integer)ids.get(l$prime);
                stateBuilder.add("name", "S" + l$primeId);
                String l$primeType = "normal";
                if (l$prime == l) {
                    l$primeType = "initial";
                }
                if (l$primeReductions.isEmpty()) {
                    l$primeType = "final";
                }
                stateBuilder.add("type", l$primeType);
                JsonArrayBuilder transitionsBuilder = Json.createArrayBuilder();
                HashSet<String> transitionStrings = new HashSet<String>();
                for (Reduction reduction : l$prime.getReductions()) {
                    JsonObjectBuilder transitionBuilder = Json.createObjectBuilder();
                    Alpha a$prime = reduction.a;
                    Loc l$prime$prime = (Loc)reduction.t$prime;
                    int l$prime$primeId = -1;
                    if (ids.containsKey(l$prime$prime)) {
                        l$prime$primeId = (Integer)ids.get(l$prime$prime);
                    } else {
                        for (Map.Entry e$ast : ids.entrySet()) {
                            if (!Protocol.areBisimilar(l$prime$prime, (Loc)e$ast.getKey())) continue;
                            l$prime$primeId = (Integer)e$ast.getValue();
                            break;
                        }
                        if (l$prime$primeId == -1) {
                            l$prime$primeId = nextId++;
                            ids.put(l$prime$prime, l$prime$primeId);
                            todo.add(l$prime$prime);
                        }
                    }
                    if (a$prime instanceof Send) {
                        Send send = (Send)a$prime;
                        transitionBuilder.add("op", "send");
                        transitionBuilder.add("message", send.l);
                        transitionBuilder.add("role", send.q.toString());
                    }
                    if (a$prime instanceof Recv) {
                        Recv recv = (Recv)a$prime;
                        transitionBuilder.add("op", "recv");
                        transitionBuilder.add("message", recv.l);
                        transitionBuilder.add("role", recv.p.toString());
                    }
                    transitionBuilder.add("next", "S" + l$prime$primeId);
                    JsonObject transition = transitionBuilder.build();
                    String s = f.apply(transition);
                    if (transitionStrings.contains(s)) continue;
                    transitionStrings.add(s);
                    transitionsBuilder.add(transition);
                }
                stateBuilder.add("transitions", transitionsBuilder);
                statesBuilder.add(stateBuilder);
            }
            b.add("states", statesBuilder);
            protocolBuilder.add(b);
        }
        json2.add("protocol", protocolBuilder);
        return f.apply(json2.build());
    }

    public static class Pair<T extends Term<T>> {
        final T t1;
        final T t2;

        public Pair(T t1, T t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.t1, pair.t1) && Objects.equals(this.t2, pair.t2);
        }

        public int hashCode() {
            return Objects.hash(this.t1, this.t2);
        }
    }
}

