/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import mpstpp.Util;
import mpstpp.parser.gen.ScrBaseVisitor;
import mpstpp.parser.gen.ScrParser;
import mpstpp.terms.Role;
import mpstpp.terms.glob.Glob;
import mpstpp.terms.glob.GlobFactory;
import mpstpp.terms.glob.act.Comm;

public class ScrVisitor
extends ScrBaseVisitor<Glob> {
    private final GlobFactory factory = GlobFactory.instance;
    private final Map<String, String> types = new HashMap<String, String>();
    private final Map<String, ScrParser.MainContext> aux = new HashMap<String, ScrParser.MainContext>();
    private final Set<String> vNames = new HashSet<String>();
    private final Stack<Map<String, Role>> stack = new Stack();

    public static void main(String[] args) throws IOException {
        Glob g = Util.parseScr("/Users/sung/Desktop/mpstpp/src/test/mpstpp/Temp.scr");
        System.out.println(g);
    }

    @Override
    public Glob visitBodyChoice(ScrParser.BodyChoiceContext ctx) {
        ArrayList<Glob> operands = new ArrayList<Glob>();
        for (ScrParser.BodySeqContext ctx1 : ctx.bodySeq()) {
            Glob g1 = (Glob)this.visit(ctx1);
            operands.add(g1);
        }
        return (Glob)this.factory.makeAltFlat(operands);
    }

    @Override
    public Glob visitBodyComm(ScrParser.BodyCommContext ctx) {
        Map<String, Role> frame = this.stack.peek();
        String pText = ctx.p.getText();
        String qText = ctx.q.getText();
        if (!frame.containsKey(pText)) {
            throw new IllegalArgumentException("used but not declared: " + pText);
        }
        if (!frame.containsKey(qText)) {
            throw new IllegalArgumentException("used but not declared: " + qText);
        }
        Role p = frame.get(pText);
        Role q = frame.get(qText);
        String l = ctx.l == null ? "" : ctx.l.getText();
        String y = ctx.y == null ? "" : ctx.y.getText();
        y = this.types.getOrDefault(y, y);
        return new Comm(p, q, l, y);
    }

    @Override
    public Glob visitBodyDo(ScrParser.BodyDoContext ctx) {
        Map<String, Role> frame = this.stack.peek();
        LinkedHashMap<String, Role> frame$prime = new LinkedHashMap<String, Role>();
        String name = ctx.name.getText();
        if (!this.aux.containsKey(name)) {
            throw new IllegalArgumentException("used but not declared: " + name);
        }
        ScrParser.MainContext ctx$prime = this.aux.get(name);
        int n = 0;
        n = ctx.role().size();
        if (n != ctx$prime.role().size()) {
            throw new IllegalArgumentException("number of parameters mismatch");
        }
        for (int i = 0; i < n; ++i) {
            String text1 = ctx.role(i).getText();
            String text1$prime = ctx$prime.role(i).getText();
            if (!frame.containsKey(text1)) {
                throw new IllegalArgumentException("used but not declared: " + text1);
            }
            frame$prime.put(text1$prime, frame.get(text1));
        }
        this.stack.push(frame$prime);
        Glob g = (Glob)this.visit(ctx$prime);
        this.stack.pop();
        return g;
    }

    @Override
    public Glob visitBodyPar(ScrParser.BodyParContext ctx) {
        ArrayList<Glob> operands = new ArrayList<Glob>();
        for (ScrParser.BodySeqContext ctx1 : ctx.bodySeq()) {
            Glob g1 = (Glob)this.visit(ctx1);
            operands.add(g1);
        }
        return (Glob)this.factory.makeParFlat(operands);
    }

    @Override
    public Glob visitBodySeq(ScrParser.BodySeqContext ctx) {
        ArrayList<Glob> operands = new ArrayList<Glob>();
        for (ScrParser.BodyContext ctx1 : ctx.body()) {
            Glob g1 = (Glob)this.visit(ctx1);
            operands.add(g1);
        }
        return (Glob)this.factory.makeSeqFlat(operands);
    }

    @Override
    public Glob visitMain(ScrParser.MainContext ctx) {
        Map<String, Role> frame = this.stack.peek();
        StringBuilder vNameBuilder = new StringBuilder();
        vNameBuilder.append(ctx.name.getText());
        for (ScrParser.RoleContext ctx1 : ctx.role()) {
            String text1 = ctx1.getText();
            Role r1 = frame.get(text1);
            if (r1 == null) {
                throw new RuntimeException();
            }
            vNameBuilder.append("_").append(r1);
        }
        String vName = vNameBuilder.toString();
        if (this.vNames.contains(vName)) {
            return this.factory.makeVar(vName);
        }
        this.vNames.add(vName);
        Glob gBody = (Glob)this.visit(ctx.bodySeq());
        return this.factory.makeMu(vName, gBody);
    }

    @Override
    public Glob visitScr(ScrParser.ScrContext ctx) {
        String mainName;
        String moduleName = ctx.module.getText();
        if (!moduleName.equals(mainName = ctx.main().name.getText())) {
            throw new IllegalArgumentException("module name and main global protocol name must be the same");
        }
        for (ScrParser.TypeContext typeContext : ctx.type()) {
            String lang1 = typeContext.lang.getText();
            String name1 = typeContext.name.getText();
            String alias1 = typeContext.alias.getText();
            if (!lang1.equals("java")) {
                throw new IllegalArgumentException("unsupported target language: " + lang1);
            }
            this.types.put(alias1, name1);
        }
        this.aux.put(mainName, ctx.main());
        for (ScrParser.AuxContext auxContext : ctx.aux()) {
            String name1 = auxContext.main().name.getText();
            if (this.aux.containsKey(name1)) {
                throw new IllegalArgumentException("multiply declared: " + name1);
            }
            this.aux.put(name1, auxContext.main());
        }
        LinkedHashMap<String, Role> frame = new LinkedHashMap<String, Role>();
        for (ScrParser.RoleContext ctx1 : ctx.main().role()) {
            String text1 = ctx1.getText();
            Role r1 = new Role(text1);
            frame.put(text1, r1);
        }
        this.stack.push(frame);
        Glob glob = (Glob)this.visit(ctx.main());
        this.stack.pop();
        return glob;
    }
}

