/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import mpstpp.terms.Act;
import mpstpp.terms.Alpha;
import mpstpp.terms.Alt;
import mpstpp.terms.Axiom;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Seq;
import mpstpp.terms.Tau;
import mpstpp.terms.Term;
import mpstpp.terms.Var;

public abstract class Mu<T extends Term<T>>
implements Term<T> {
    public final String vName;
    public final T tBody;
    private static AtomicInteger freshIds = new AtomicInteger();

    public Mu(String vName, T tBody) {
        this.vName = vName;
        this.tBody = tBody;
    }

    private T newMu(String vName, T tBody) {
        return this.getFactory().makeMu(vName, tBody).cast();
    }

    private T newVar(String vName) {
        return this.getFactory().makeVar(vName).cast();
    }

    public boolean isSpecial() {
        Alt alt;
        BooleanSupplier x;
        return this.tBody instanceof Alt && (x = () -> this.lambda$isSpecial$0(alt = (Alt)this.tBody)).getAsBoolean();
    }

    @Override
    public T alphaConvert() {
        Object tBody$ast = this.tBody.alphaConvert();
        Set<String> set = tBody$ast.getVarNames();
        String vName$ast = this.vName + freshIds.getAndIncrement();
        while (set.contains(vName$ast)) {
            vName$ast = this.vName + freshIds.getAndIncrement();
        }
        LinkedHashMap<String, T> spec = new LinkedHashMap<String, T>();
        spec.put(this.vName, this.newVar(vName$ast));
        return (T)this.newMu(vName$ast, tBody$ast.bind(Collections.unmodifiableMap(spec)));
    }

    @Override
    public T bind(Map<String, T> spec) {
        LinkedHashMap<String, T> newSpec = new LinkedHashMap<String, T>(spec);
        newSpec.remove(this.vName);
        return this.newMu(this.vName, this.tBody.bind(Collections.unmodifiableMap(newSpec)));
    }

    @Override
    public boolean canTerminate() {
        return this.tBody.canTerminate();
    }

    @Override
    public T eliminateTaus() {
        Object tBody$ast = this.tBody.eliminateTaus();
        if (tBody$ast instanceof Alt) {
            ArrayList<Term> l = new ArrayList<Term>();
            for (Term t1 : tBody$ast.getSubterms()) {
                if (t1 instanceof Var && ((Var)t1).vName.equals(this.vName)) continue;
                l.add(t1);
            }
            if (l.isEmpty()) {
                return this.getFactory().makeOne().cast();
            }
            return this.newMu(this.vName, this.getFactory().makeAltFlat(l));
        }
        return this.newMu(this.vName, this.tBody.eliminateTaus());
    }

    @Override
    public boolean endsWith(String vName) {
        return this.tBody.endsWith(vName);
    }

    @Override
    public Set<Act<T>> getActs() {
        return this.tBody.getActs();
    }

    @Override
    public Set<T> getEqualsUpTo(List<Axiom> axioms) {
        LinkedHashSet<Object> s = new LinkedHashSet<Object>();
        for (Term tBody$ast : this.tBody.getEqualsUpTo(axioms)) {
            if (axioms.contains((Object)Axiom.WUng1)) {
                if (tBody$ast instanceof Alt) {
                    ArrayList<Term> l = new ArrayList<Term>();
                    Term lastSummand = null;
                    Iterator iterator = tBody$ast.getSubterms().iterator();
                    while (iterator.hasNext()) {
                        Term tBody1$ast;
                        lastSummand = tBody1$ast = (Term)iterator.next();
                        if (tBody1$ast instanceof Seq) {
                            Term tBody11$ast = (Term)tBody1$ast.getSubterms().get(0);
                            Term tBody12$ast = (Term)tBody1$ast.getSubterms().get(1);
                            if (tBody11$ast instanceof Tau && tBody12$ast instanceof Var) continue;
                        }
                        l.add(tBody1$ast);
                    }
                    if (l.isEmpty()) {
                        l.add(lastSummand);
                    }
                    for (Term tBody$dag : this.getFactory().makeAltFlat(l).getEqualsUpTo(axioms)) {
                        Object tVar = this.getFactory().makeVar(this.vName).cast();
                        if (tBody$dag.getFreeVars().contains(tVar)) {
                            if (!tBody$dag.equals(this.tBody)) {
                                s.addAll(this.newMu(this.vName, tBody$dag).getEqualsUpTo(axioms));
                                continue;
                            }
                            s.add(this.newMu(this.vName, tBody$dag));
                            continue;
                        }
                        s.add(tBody$dag);
                    }
                    continue;
                }
                s.add(this.newMu(this.vName, tBody$ast));
                continue;
            }
            s.add(this.newMu(this.vName, tBody$ast));
        }
        return s;
    }

    @Override
    public Set<T> getFreeVars() {
        HashSet s = new HashSet(this.tBody.getFreeVars());
        s.remove(this.getFactory().makeVar(this.vName).cast());
        return s;
    }

    @Override
    public Set<Mu<T>> getMus() {
        LinkedHashSet s = new LinkedHashSet(this.tBody.getMus());
        s.add(this);
        return s;
    }

    @Override
    public Set<Reduction<T>> getReductions() {
        LinkedHashSet<Reduction<T>> s = new LinkedHashSet<Reduction<T>>();
        Object t = this.cast();
        for (Reduction rBody : this.unfold().getReductions()) {
            Alpha a = rBody.a;
            Object t$prime = rBody.t$prime;
            Reduction r = new Reduction(t, a, t$prime);
            s.add(r);
        }
        return s;
    }

    @Override
    public Set<Role> getRoles() {
        return this.tBody.getRoles();
    }

    @Override
    public List<T> getSubterms() {
        return Arrays.asList(null, this.tBody);
    }

    @Override
    public Set<String> getVarNames() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.add(this.vName);
        s.addAll(this.tBody.getVarNames());
        return s;
    }

    @Override
    public boolean hasNoOccurrencesOfOne() {
        return this.tBody.hasNoOccurrencesOfOne();
    }

    @Override
    public boolean hasNoOccurrencesOfTau() {
        return this.tBody.hasNoOccurrencesOfTau();
    }

    @Override
    public boolean hasOnlyAsyncOccurrencesOf(Act a) {
        return this.tBody.hasOnlyAsyncOccurrencesOf(a);
    }

    @Override
    public boolean hasOnlyOccurrencesOfTau() {
        return this.tBody.hasOnlyOccurrencesOfTau();
    }

    @Override
    public boolean isDeterministic() {
        return this.tBody.isDeterministic();
    }

    @Override
    public boolean isFinal() {
        return this.tBody.isFinal();
    }

    @Override
    public boolean isGuarded() {
        return this.tBody.isGuarded();
    }

    @Override
    public T simplify() {
        Object tBody$ast = this.tBody.simplify();
        Object tVar = this.getFactory().makeVar(this.vName).cast();
        if (!tBody$ast.getFreeVars().contains(tVar)) {
            return tBody$ast;
        }
        return this.newMu(this.vName, tBody$ast);
    }

    @Override
    public String toMCRL2(String procPrefix) {
        return procPrefix + "_" + this.vName;
    }

    @Override
    public T unfold() {
        LinkedHashMap newSpec = new LinkedHashMap();
        newSpec.put(this.vName, this.cast());
        return (T)this.tBody.bind(Collections.unmodifiableMap(newSpec));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mu mu = (Mu)o;
        return Objects.equals(this.vName, mu.vName) && Objects.equals(this.tBody, mu.tBody);
    }

    public int hashCode() {
        return Objects.hash(this.vName, this.tBody);
    }

    public String toString() {
        return "(mu " + this.vName + " " + this.tBody + ")";
    }

    private /* synthetic */ boolean lambda$isSpecial$0(Alt alt) {
        int nonempties = 0;
        for (Term t$prime : alt.getSubterms()) {
            boolean nonempty = false;
            for (Act a : t$prime.getActs()) {
                if (a instanceof Tau) continue;
                nonempty = true;
                break;
            }
            boolean bl = nonempty = nonempty || t$prime.endsWith(this.vName);
            if (nonempty) {
                ++nonempties;
            }
            if (nonempties <= 1) continue;
            return false;
        }
        return true;
    }
}

