/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import mpstpp.terms.Act;
import mpstpp.terms.Alpha;
import mpstpp.terms.Axiom;
import mpstpp.terms.Mu;
import mpstpp.terms.One;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Tau;
import mpstpp.terms.Term;

public abstract class Par<T extends Term<T>>
implements Term<T> {
    public final List<T> subterms;

    public Par(List<T> subterms) {
        this.subterms = subterms;
    }

    private T newPar(List<T> subterms) {
        return this.getFactory().makeParFlat(subterms).cast();
    }

    @Override
    public T alphaConvert() {
        ArrayList l = new ArrayList();
        for (Term t1 : this.subterms) {
            l.add(t1.alphaConvert());
        }
        return (T)this.newPar(l);
    }

    @Override
    public T bind(Map<String, T> spec) {
        ArrayList<T> l = new ArrayList<T>();
        for (Term t1 : this.subterms) {
            l.add(t1.bind(spec));
        }
        return (T)this.newPar(l);
    }

    @Override
    public boolean canTerminate() {
        for (Term t1 : this.subterms) {
            if (t1.canTerminate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String vName) {
        for (Term t1 : this.subterms) {
            if (!t1.endsWith(vName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T eliminateTaus() {
        ArrayList l = new ArrayList();
        for (Term t1 : this.subterms) {
            Object t1$ast = t1.eliminateTaus();
            if (t1$ast instanceof Tau) continue;
            l.add(t1$ast);
        }
        return (T)(l.isEmpty() ? this.getFactory().makeOne().cast() : this.newPar(l));
    }

    @Override
    public Set<Act<T>> getActs() {
        LinkedHashSet<Act<T>> s = new LinkedHashSet<Act<T>>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getActs());
        }
        return s;
    }

    @Override
    public Set<T> getEqualsUpTo(final List<Axiom> axioms) {
        class Recursion
        implements BiFunction<Integer, Stack<T>, Set<T>> {
            Recursion() {
            }

            @Override
            public Set<T> apply(Integer i, Stack<T> stack) {
                LinkedHashSet s = new LinkedHashSet();
                if (i.intValue() == Par.this.subterms.size()) {
                    ArrayList l = new ArrayList();
                    if (axioms.contains((Object)Axiom.WTM)) {
                        Term firstTau = null;
                        for (Term t : stack) {
                            if (t instanceof Tau) {
                                firstTau = firstTau == null ? t : firstTau;
                                continue;
                            }
                            l.add(t);
                        }
                        if (l.isEmpty()) {
                            l.add(firstTau);
                        }
                    } else {
                        l.addAll(stack);
                    }
                    s.add(Par.this.newPar(l));
                } else {
                    Term t1 = (Term)Par.this.subterms.get(i);
                    for (Term t1$ast : t1.getEqualsUpTo(axioms)) {
                        stack.push(t1$ast);
                        s.addAll(this.apply(i + 1, stack));
                        stack.pop();
                    }
                }
                return s;
            }
        }
        return new Recursion().apply(0, new Stack());
    }

    @Override
    public Set<T> getFreeVars() {
        HashSet s = new HashSet();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getFreeVars());
        }
        return s;
    }

    @Override
    public Set<Mu<T>> getMus() {
        LinkedHashSet<Mu<T>> s = new LinkedHashSet<Mu<T>>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getMus());
        }
        return s;
    }

    @Override
    public Set<Reduction<T>> getReductions() {
        LinkedHashSet<Reduction<T>> s = new LinkedHashSet<Reduction<T>>();
        Object t = this.cast();
        for (int i = 0; i < this.subterms.size(); ++i) {
            Term t1 = (Term)this.subterms.get(i);
            for (Reduction r1 : t1.getReductions()) {
                Alpha a = r1.a;
                Object t1$prime = r1.t$prime;
                ArrayList<T> l = new ArrayList<T>(this.subterms.subList(0, i));
                l.add(t1$prime);
                l.addAll(this.subterms.subList(i + 1, this.subterms.size()));
                T t$prime = this.newPar(l);
                Reduction r = new Reduction(t, a, t$prime);
                s.add(r);
            }
        }
        return s;
    }

    @Override
    public Set<Role> getRoles() {
        LinkedHashSet<Role> s = new LinkedHashSet<Role>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getRoles());
        }
        return s;
    }

    @Override
    public List<T> getSubterms() {
        return new ArrayList<T>(this.subterms);
    }

    @Override
    public Set<String> getVarNames() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getVarNames());
        }
        return s;
    }

    @Override
    public boolean hasNoOccurrencesOfOne() {
        for (Term t1 : this.subterms) {
            if (t1.hasNoOccurrencesOfOne()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNoOccurrencesOfTau() {
        for (Term t1 : this.subterms) {
            if (t1.hasNoOccurrencesOfTau()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOnlyAsyncOccurrencesOf(Act a) {
        for (Term t1 : this.subterms) {
            if (t1.equals(a) || t1.hasOnlyAsyncOccurrencesOf(a)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOnlyOccurrencesOfTau() {
        for (Term t1 : this.subterms) {
            if (t1.hasOnlyOccurrencesOfTau()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDeterministic() {
        ArrayList l = new ArrayList();
        for (Term term : this.subterms) {
            if (!term.isDeterministic()) {
                return false;
            }
            l.add(term.getActs());
        }
        for (Set set : l) {
            for (Set set2 : l) {
                if (set == set2) continue;
                for (Act a1 : set) {
                    for (Act a2 : set2) {
                        if (!a1.equals(a2)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean isFinal() {
        for (Term t1 : this.subterms) {
            if (t1.isFinal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isGuarded() {
        for (Term t1 : this.subterms) {
            if (t1.isGuarded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public T simplify() {
        ArrayList l = new ArrayList();
        for (Term t1 : this.subterms) {
            Object t1$ast = t1.simplify();
            if (t1$ast instanceof One) continue;
            if (t1$ast instanceof Par) {
                l.addAll(t1.getSubterms());
                continue;
            }
            l.add(t1$ast);
        }
        return (T)this.newPar(l);
    }

    @Override
    public String toMCRL2(String procPrefix) {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (Term t1 : this.subterms) {
            b.append(t1.toMCRL2(procPrefix));
            b.append(" || ");
        }
        b.delete(b.length() - 4, b.length());
        b.append(")");
        return b.toString();
    }

    @Override
    public T unfold() {
        return this.cast();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Par par = (Par)o;
        ArrayList<T> l1 = new ArrayList<T>(this.subterms);
        ArrayList<T> l2 = new ArrayList<T>(par.subterms);
        Comparator<Term> c = Comparator.comparing(Object::toString);
        l1.sort(c);
        l2.sort(c);
        return Objects.equals(l1, l2);
    }

    public int hashCode() {
        ArrayList<T> l = new ArrayList<T>(this.subterms);
        Comparator<Term> c = Comparator.comparing(Object::toString);
        l.sort(c);
        return Objects.hash(l);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (Term t1 : this.subterms) {
            b.append(t1);
            b.append(" | ");
        }
        b.delete(b.length() - 3, b.length());
        b.append(")");
        return b.toString();
    }
}

