/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import mpstpp.terms.Alpha;
import mpstpp.terms.Reduction;
import mpstpp.terms.Tau;
import mpstpp.terms.Term;

public class Reductions {
    public static <T extends Term<T>> Set<Reduction<T>> getReductions(T t, Predicate<Reduction<T>> filter) {
        LinkedHashSet<Reduction<T>> s = new LinkedHashSet<Reduction<T>>();
        for (Reduction<T> r : t.getReductions()) {
            if (!filter.test(r)) continue;
            s.add(r);
        }
        return s;
    }

    public static <T extends Term<T>> Set<Reduction<T>> getStarReductions(T t, int depth) {
        class GetTauReductions
        implements BiFunction<T, Integer, Set<Reduction<T>>> {
            private final Set<T> done = new HashSet();

            GetTauReductions() {
            }

            @Override
            public Set<Reduction<T>> apply(T t, Integer depth) {
                LinkedHashSet s = new LinkedHashSet();
                if (depth < 1) {
                    return s;
                }
                if (this.done.contains(t)) {
                    return s;
                }
                this.done.add(t);
                for (Reduction r : t.getReductions()) {
                    Alpha a = r.a;
                    Object t$prime = r.t$prime.cast();
                    if (!(a instanceof Tau)) continue;
                    s.add(new Reduction(t, Tau.instance, t$prime));
                    for (Reduction r$prime : this.apply(t$prime, depth - 1)) {
                        Object t$prime$prime = r$prime.t$prime;
                        s.add(new Reduction(t, Tau.instance, t$prime$prime));
                    }
                }
                return s;
            }
        }
        return new GetTauReductions().apply(t, depth);
    }

    public static <T extends Term<T>> Set<T> getSuccessors(T t) {
        return Reductions.getSuccessors(t, r -> true);
    }

    public static <T extends Term<T>> Set<T> getSuccessors(T t, Predicate<Reduction<T>> filter) {
        LinkedHashSet s = new LinkedHashSet();
        for (Reduction<T> r : Reductions.getReductions(t, filter)) {
            Object t$prime = r.t$prime;
            s.add(t$prime);
        }
        return s;
    }
}

