/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import mpstpp.terms.Act;
import mpstpp.terms.Alpha;
import mpstpp.terms.Axiom;
import mpstpp.terms.Mu;
import mpstpp.terms.One;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Tau;
import mpstpp.terms.Term;

public abstract class Seq<T extends Term<T>>
implements Term<T> {
    public final List<T> subterms;

    public Seq(List<T> subterms) {
        this.subterms = subterms;
    }

    private T newSeq(List<T> subterms) {
        return this.getFactory().makeSeqFlat(subterms);
    }

    @Override
    public T alphaConvert() {
        ArrayList l = new ArrayList();
        for (Term t1 : this.subterms) {
            l.add(t1.alphaConvert());
        }
        return (T)this.newSeq(l);
    }

    @Override
    public T bind(Map<String, T> spec) {
        ArrayList<T> l = new ArrayList<T>();
        for (Term t1 : this.subterms) {
            l.add(t1.bind(spec));
        }
        return (T)this.newSeq(l);
    }

    @Override
    public boolean canTerminate() {
        for (Term t1 : this.subterms) {
            if (t1.canTerminate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public T eliminateTaus() {
        ArrayList l = new ArrayList();
        for (Term t1 : this.subterms) {
            Object t1$ast = t1.eliminateTaus();
            if (t1$ast instanceof Tau) continue;
            l.add(t1$ast);
        }
        return (T)(l.isEmpty() ? this.getFactory().makeOne().cast() : this.newSeq(l));
    }

    @Override
    public boolean endsWith(String vName) {
        for (Term t1 : this.subterms) {
            if (t1.endsWith(vName)) {
                return true;
            }
            if (t1.canTerminate()) continue;
            return false;
        }
        return false;
    }

    @Override
    public Set<Act<T>> getActs() {
        LinkedHashSet<Act<T>> s = new LinkedHashSet<Act<T>>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getActs());
        }
        return s;
    }

    @Override
    public Set<T> getEqualsUpTo(final List<Axiom> axioms) {
        class Recursion
        implements BiFunction<Integer, Stack<T>, Set<T>> {
            Recursion() {
            }

            @Override
            public Set<T> apply(Integer i, Stack<T> stack) {
                LinkedHashSet s = new LinkedHashSet();
                if (i.intValue() == Seq.this.subterms.size()) {
                    ArrayList l = new ArrayList();
                    if (axioms.contains((Object)Axiom.W) || axioms.contains((Object)Axiom.WT)) {
                        int first = axioms.contains((Object)Axiom.WT) ? 0 : 1;
                        int last = stack.size() - (axioms.contains((Object)Axiom.W) ? 0 : 1);
                        Term firstTau = null;
                        for (int j = first; j < last; ++j) {
                            Term t = (Term)stack.get(j);
                            if (t instanceof Tau) {
                                firstTau = firstTau == null ? t : firstTau;
                                continue;
                            }
                            l.add(t);
                        }
                        if (!axioms.contains((Object)Axiom.WT)) {
                            l.add(0, (Term)stack.get(0));
                        }
                        if (!axioms.contains((Object)Axiom.W)) {
                            l.add((Term)stack.get(stack.size() - 1));
                        }
                        if (l.isEmpty()) {
                            l.add(firstTau);
                        }
                    } else {
                        l.addAll(stack);
                    }
                    s.add(Seq.this.newSeq(l));
                } else {
                    Term t1 = (Term)Seq.this.subterms.get(i);
                    for (Term t1$ast : t1.getEqualsUpTo(axioms)) {
                        stack.push(t1$ast);
                        s.addAll(this.apply(i + 1, stack));
                        stack.pop();
                    }
                }
                return s;
            }
        }
        return new Recursion().apply(0, new Stack());
    }

    @Override
    public Set<T> getFreeVars() {
        HashSet s = new HashSet();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getFreeVars());
        }
        return s;
    }

    @Override
    public Set<Mu<T>> getMus() {
        LinkedHashSet<Mu<T>> s = new LinkedHashSet<Mu<T>>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getMus());
        }
        return s;
    }

    @Override
    public Set<Reduction<T>> getReductions() {
        LinkedHashSet<Reduction<T>> s = new LinkedHashSet<Reduction<T>>();
        Object t = this.cast();
        for (int i = 0; i < this.subterms.size(); ++i) {
            Term t1 = (Term)this.subterms.get(i);
            for (Reduction r1 : t1.getReductions()) {
                Alpha a = r1.a;
                Object t1$prime = r1.t$prime;
                ArrayList<T> l = new ArrayList<T>();
                l.add(t1$prime);
                l.addAll(this.subterms.subList(i + 1, this.subterms.size()));
                Object t$prime = l.size() == 1 ? t1$prime : this.newSeq(l);
                Reduction r = new Reduction(t, a, t$prime);
                s.add(r);
            }
            if (!t1.isFinal()) break;
        }
        return s;
    }

    @Override
    public Set<Role> getRoles() {
        LinkedHashSet<Role> s = new LinkedHashSet<Role>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getRoles());
        }
        return s;
    }

    @Override
    public List<T> getSubterms() {
        return new ArrayList<T>(this.subterms);
    }

    @Override
    public Set<String> getVarNames() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (Term t1 : this.subterms) {
            s.addAll(t1.getVarNames());
        }
        return s;
    }

    @Override
    public boolean hasNoOccurrencesOfOne() {
        for (Term t1 : this.subterms) {
            if (t1.hasNoOccurrencesOfOne()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNoOccurrencesOfTau() {
        for (Term t1 : this.subterms) {
            if (t1.hasNoOccurrencesOfTau()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOnlyAsyncOccurrencesOf(Act a) {
        for (Term t1 : this.subterms) {
            if (t1.hasOnlyAsyncOccurrencesOf(a)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOnlyOccurrencesOfTau() {
        for (Term t1 : this.subterms) {
            if (t1.hasOnlyOccurrencesOfTau()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDeterministic() {
        for (Term t1 : this.subterms) {
            if (t1.isDeterministic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFinal() {
        for (Term t1 : this.subterms) {
            if (t1.isFinal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isGuarded() {
        return ((Term)this.subterms.get(0)).isGuarded();
    }

    @Override
    public T simplify() {
        ArrayList l = new ArrayList();
        for (Term t1 : this.subterms) {
            Object t1$ast = t1.simplify();
            if (t1$ast instanceof One) continue;
            if (t1$ast instanceof Seq) {
                l.addAll(t1$ast.getSubterms());
                continue;
            }
            l.add(t1$ast);
        }
        return (T)this.newSeq(l);
    }

    @Override
    public String toMCRL2(String procPrefix) {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (Term t1 : this.subterms) {
            b.append(t1.toMCRL2(procPrefix));
            b.append(" . ");
        }
        b.delete(b.length() - 3, b.length());
        b.append(")");
        return b.toString();
    }

    @Override
    public T unfold() {
        return this.cast();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Seq seq = (Seq)o;
        return Objects.equals(this.subterms, seq.subterms);
    }

    public int hashCode() {
        return Objects.hash(this.subterms);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (Term t1 : this.subterms) {
            b.append(t1);
            b.append(" . ");
        }
        b.delete(b.length() - 3, b.length());
        b.append(")");
        return b.toString();
    }
}

