/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpstpp.terms.Act;
import mpstpp.terms.Alpha;
import mpstpp.terms.Axiom;
import mpstpp.terms.Mu;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Tau;
import mpstpp.terms.TermFactory;

public interface Term<T extends Term<T>> {
    public T alphaConvert();

    default public boolean equalsUpTo(T t, Axiom ... axioms) {
        return this.equalsUpTo(t, Arrays.asList(axioms));
    }

    default public boolean equalsUpTo(T t, List<Axiom> axioms) {
        if (this.equals(t)) {
            return true;
        }
        Set<T> s1 = this.getEqualsUpTo(axioms);
        Set<T> s2 = t.getEqualsUpTo(axioms);
        if (s1.size() == 1 && s2.size() == 1) {
            boolean equal;
            Term t2;
            Term t1 = (Term)s1.iterator().next();
            if (t1.equals(t2 = (Term)s2.iterator().next()) || t1.unfold().equals(t2)) {
                return true;
            }
            Set<Reduction<T>> reductions1 = t1.getReductions();
            Set<Reduction<T>> reductions2 = t2.getReductions();
            for (Reduction<T> r1 : reductions1) {
                Alpha a1 = r1.a;
                Object t1$prime = r1.t$prime;
                equal = false;
                if (a1 instanceof Tau) {
                    equal = t1$prime.equals(t2);
                } else {
                    for (Reduction<T> r2 : reductions2) {
                        Alpha a2 = r2.a;
                        Object t2$prime = r2.t$prime;
                        if (!a1.equals(a2)) continue;
                        equal = equal || t1$prime.equals(t2$prime) || t1.equals(t1$prime) && t2.equals(t2$prime);
                    }
                }
                if (equal) continue;
                return false;
            }
            for (Reduction<T> r2 : reductions2) {
                Alpha a2 = r2.a;
                Object t2$prime = r2.t$prime;
                equal = false;
                if (a2 instanceof Tau) {
                    equal = t2$prime.equals(t1);
                } else {
                    for (Reduction<T> r1 : reductions1) {
                        Alpha a1 = r1.a;
                        Object t1$prime = r1.t$prime;
                        if (!a2.equals(a1)) continue;
                        equal = equal || t2$prime.equals(t1$prime) || t1.equals(t1$prime) && t2.equals(t2$prime);
                    }
                }
                if (equal) continue;
                return false;
            }
            return true;
        }
        s1.retainAll(s2);
        return !s1.isEmpty();
    }

    public T bind(Map<String, T> var1);

    public boolean canTerminate();

    public T cast();

    public boolean endsWith(String var1);

    public T eliminateTaus();

    public Set<Act<T>> getActs();

    default public Set<T> getEqualsUpTo(Axiom ... axioms) {
        return this.getEqualsUpTo(Arrays.asList(axioms));
    }

    public Set<T> getEqualsUpTo(List<Axiom> var1);

    public TermFactory<T> getFactory();

    public Set<T> getFreeVars();

    public Set<Mu<T>> getMus();

    public Set<String> getVarNames();

    public Set<Reduction<T>> getReductions();

    public Set<Role> getRoles();

    public List<T> getSubterms();

    public boolean hasNoOccurrencesOfOne();

    public boolean hasNoOccurrencesOfTau();

    public boolean hasOnlyAsyncOccurrencesOf(Act var1);

    public boolean hasOnlyOccurrencesOfTau();

    default public boolean isClosed() {
        return this.getFreeVars().isEmpty();
    }

    public boolean isDeterministic();

    public boolean isFinal();

    public boolean isGuarded();

    public T simplify();

    public T unfold();

    public String toMCRL2(String var1);
}

