/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.ArrayList;
import java.util.List;
import mpstpp.terms.Alt;
import mpstpp.terms.Mu;
import mpstpp.terms.One;
import mpstpp.terms.Par;
import mpstpp.terms.Seq;
import mpstpp.terms.Term;
import mpstpp.terms.Var;

public interface TermFactory<T extends Term<T>> {
    public Alt<T> makeAlt(List<T> var1);

    default public T makeAltFlat(List<T> subterms) {
        if (subterms.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (subterms.size() == 1) {
            return (T)((Term)subterms.get(0));
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Term t : subterms) {
            if (t instanceof Alt) {
                l.addAll(t.getSubterms());
                continue;
            }
            l.add(t);
        }
        ArrayList<Term> l$ast = new ArrayList<Term>();
        for (Term term : l) {
            if (l$ast.contains(term)) continue;
            l$ast.add(term);
        }
        return this.makeAlt(l$ast).cast();
    }

    public Mu<T> makeMu(String var1, T var2);

    public One<T> makeOne();

    public Par<T> makePar(List<T> var1);

    default public T makeParFlat(List<T> subterms) {
        if (subterms.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (subterms.size() == 1) {
            return (T)((Term)subterms.get(0));
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Term t : subterms) {
            if (t instanceof Par) {
                l.addAll(t.getSubterms());
                continue;
            }
            l.add(t);
        }
        return this.makePar(l).cast();
    }

    public Seq<T> makeSeq(List<T> var1);

    default public T makeSeqFlat(List<T> subterms) {
        if (subterms.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (subterms.size() == 1) {
            return (T)((Term)subterms.get(0));
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Term t : subterms) {
            if (t instanceof Seq) {
                l.addAll(t.getSubterms());
                continue;
            }
            l.add(t);
        }
        return this.makeSeq(l).cast();
    }

    public Var<T> makeVar(String var1);
}

