/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import mpstpp.terms.Act;
import mpstpp.terms.Alpha;
import mpstpp.terms.Axiom;
import mpstpp.terms.Mu;
import mpstpp.terms.Par;
import mpstpp.terms.Reduction;
import mpstpp.terms.Reductions;
import mpstpp.terms.Role;
import mpstpp.terms.Tau;
import mpstpp.terms.Term;

public class Terms {
    public static <T extends Term<T>> boolean isChain(T t, Set<T> successors) {
        if (t instanceof Par) {
            successors.addAll(t.getSubterms());
            return true;
        }
        Set<Reduction<T>> reductions = t.getReductions();
        if (reductions.size() > 1) {
            Iterator<Reduction<T>> i = reductions.iterator();
            Reduction<T> r1 = i.next();
            Alpha a1 = r1.a;
            Object t1$prime = r1.t$prime;
            while (i.hasNext()) {
                Reduction<T> r2 = i.next();
                Alpha a2 = r2.a;
                Object t2$prime = r2.t$prime;
                if (a1.equals(a2) && t1$prime.equalsUpTo(t2$prime, Axiom.values())) continue;
                return false;
            }
        }
        for (Reduction<T> r : reductions) {
            Alpha a = r.a;
            Object t$prime = r.t$prime;
            for (Reduction<T> r$prime : t$prime.getReductions()) {
                Alpha a$prime = r$prime.a;
                Object t$prime$prime = r$prime.t$prime;
                HashSet<Role> roles = new HashSet<Role>(a.getRoles());
                roles.retainAll(a$prime.getRoles());
                if (roles.isEmpty()) {
                    return false;
                }
                boolean ok = true;
                if (a$prime instanceof Tau) {
                    ArrayList todo = new ArrayList();
                    HashSet<Term> done = new HashSet<Term>();
                    todo.add(t$prime$prime);
                    block3: while (ok && !todo.isEmpty()) {
                        Term t$ast = (Term)todo.remove(0);
                        if (done.contains(t$ast)) continue;
                        if (t$ast instanceof Par) {
                            ok = false;
                            continue;
                        }
                        done.add(t$ast);
                        if (t$ast.equals(t$prime)) continue;
                        for (Reduction r$ast : t$ast.getReductions()) {
                            Alpha a$ast = r$ast.a;
                            Object t$ast$ast = r$ast.t$prime;
                            if (a$ast instanceof Tau) {
                                todo.add(t$ast$ast);
                                continue;
                            }
                            ok = false;
                            continue block3;
                        }
                    }
                }
                if (ok) continue;
                successors.add(t$prime);
            }
        }
        return true;
    }

    public static <T extends Term<T>> boolean isChainCoinductively(T t) {
        return new Coinduction<Term>(Terms::isChain).test(t);
    }

    public static <T extends Term<T>> boolean isDeterministic(T t, Set<T> successors) {
        if (t instanceof Par) {
            Par par = (Par)t;
            if (par.subterms.size() == 2) {
                Term t1 = (Term)par.subterms.get(0);
                Term t2 = (Term)par.subterms.get(1);
                if (t1 instanceof Act && t2.hasOnlyAsyncOccurrencesOf((Act)t1)) {
                    return true;
                }
                if (t2 instanceof Act && t1.hasOnlyAsyncOccurrencesOf((Act)t2)) {
                    return true;
                }
            }
        }
        Set<Reduction<T>> reductions = t.getReductions();
        HashMap actionsToTerms = new HashMap();
        for (Reduction<T> r : reductions) {
            Object t$prime = r.t$prime;
            Alpha a = r.a;
            Term t$ast = (Term)actionsToTerms.getOrDefault(a, t$prime);
            if (!t$prime.equals(t$ast)) {
                return false;
            }
            actionsToTerms.put(r.a, r.t$prime);
        }
        successors.addAll(Reductions.getSuccessors(t));
        return true;
    }

    public static <T extends Term<T>> boolean isDeterministicCoinductively(T t) {
        return new Coinduction<Term>(Terms::isDeterministic).test(t);
    }

    public static <T extends Term<T>> boolean isDiamond(T t, Set<T> successors) {
        Mu mu;
        if (t instanceof Par) {
            successors.addAll(t.getSubterms());
            return true;
        }
        if (t instanceof Mu && (mu = (Mu)t).isSpecial()) {
            return true;
        }
        for (Reduction<T> r2 : Reductions.getReductions(t, r -> r.a instanceof Tau)) {
            Tau tau = (Tau)r2.a;
            if (Terms.isTauNeutral(t, tau) || Terms.isTauDiamond(t, tau)) continue;
            return false;
        }
        successors.addAll(Reductions.getSuccessors(t));
        return true;
    }

    public static <T extends Term<T>> boolean isDiamondCoinductively(T t) {
        return new Coinduction<Term>(Terms::isDiamond, true).test(t);
    }

    public static <T extends Term<T>> boolean isHeart(T t, Set<T> successors) {
        Mu mu;
        if (t instanceof Par) {
            boolean ok = true;
            for (Term t1 : t.getSubterms()) {
                ok = ok && Terms.isChainCoinductively(t1);
            }
            return ok || Terms.isHeartParCoinductively(t);
        }
        if (t instanceof Mu && (mu = (Mu)t).isSpecial()) {
            return true;
        }
        if (Terms.isChainCoinductively(t)) {
            return true;
        }
        for (Reduction<T> r1 : Reductions.getReductions(t, r -> r.a instanceof Tau)) {
            Object t1$prime = r1.t$prime;
            for (Reduction r1$prime : Reductions.getReductions(t1$prime, r -> !(r.a instanceof Tau))) {
                Alpha a = r1$prime.a;
                Object t1$prime$prime = r1$prime.t$prime;
                BooleanSupplier x = () -> {
                    for (Reduction<Term> r2 : Reductions.getReductions(t, r -> r.a.equals(a))) {
                        Object t2$prime = r2.t$prime;
                        for (Reduction r2$prime : Reductions.getReductions(t2$prime, r -> r.a instanceof Tau)) {
                            Object t2$prime$prime = r2$prime.t$prime;
                            if (!t1$prime$prime.equalsUpTo(t2$prime$prime, Axiom.values())) continue;
                            return true;
                        }
                        if (!t1$prime$prime.equalsUpTo(t2$prime, Axiom.values())) continue;
                        return true;
                    }
                    return false;
                };
                if (x.getAsBoolean()) continue;
                return false;
            }
        }
        successors.addAll(Reductions.getSuccessors(t));
        return true;
    }

    public static <T extends Term<T>> boolean isHeartCoinductively(T t) {
        return new Coinduction<Term>(Terms::isHeart).test(t);
    }

    public static <T extends Term<T>> boolean isHeartPar(T t, Set<T> successors) {
        if (t instanceof Par) {
            successors.addAll(t.getSubterms());
            return true;
        }
        for (Reduction<T> r1 : Reductions.getReductions(t, r -> r.a instanceof Tau)) {
            Object t1$prime = r1.t$prime;
            for (Reduction r1$prime : Reductions.getReductions(t1$prime, r -> !(r.a instanceof Tau))) {
                Alpha a = r1$prime.a;
                Object t1$prime$prime = r1$prime.t$prime;
                BooleanSupplier x = () -> {
                    for (Reduction<Term> r2 : Reductions.getReductions(t, r -> r.a.equals(a))) {
                        Object t2$prime = r2.t$prime;
                        for (Reduction r2$prime : Reductions.getReductions(t2$prime, r -> r.a instanceof Tau)) {
                            Object t2$prime$prime = r2$prime.t$prime;
                            if (!t1$prime$prime.equalsUpTo(t2$prime$prime, Axiom.values())) continue;
                            return true;
                        }
                        if (!t1$prime$prime.equalsUpTo(t2$prime, Axiom.values())) continue;
                        return true;
                    }
                    return false;
                };
                if (x.getAsBoolean()) continue;
                return false;
            }
        }
        successors.addAll(Reductions.getSuccessors(t));
        return true;
    }

    public static <T extends Term<T>> boolean isHeartParCoinductively(T t) {
        return new Coinduction<Term>(Terms::isHeartPar).test(t);
    }

    public static <T extends Term<T>> boolean isTauNeutral(T t, Tau tau) {
        for (Reduction<T> r2 : Reductions.getReductions(t, r -> r.a.equals(tau))) {
            Object t$prime = r2.t$prime;
            if (t.equalsUpTo(t$prime, Axiom.values())) continue;
            return false;
        }
        return true;
    }

    public static <T extends Term<T>> boolean isTauDiamond(T t, Tau tau) {
        for (Reduction<T> r1 : Reductions.getReductions(t, r -> r.a.equals(tau))) {
            Alpha a1 = r1.a;
            Object t1$prime = r1.t$prime;
            for (Reduction<T> r2 : t.getReductions()) {
                Alpha a2 = r2.a;
                Object t2$prime = r2.t$prime;
                if (r1.equals(r2)) continue;
                boolean eq = false;
                Set<Term> s1 = Reductions.getSuccessors(t1$prime, r -> r.a.equals(a2));
                Set<Term> s2 = Reductions.getSuccessors(t2$prime, r -> r.a.equals(a1));
                Axiom[] axioms = Axiom.values();
                if (a2 instanceof Tau && t1$prime.equalsUpTo(t2$prime, axioms)) {
                    eq = true;
                }
                for (Term t1$prime$prime : s1) {
                    if (eq || !t1$prime$prime.equalsUpTo(t2$prime, axioms)) continue;
                    eq = true;
                }
                for (Term t2$prime$prime : s1) {
                    if (eq || !(a2 instanceof Tau) || !t2$prime$prime.equalsUpTo(t1$prime, axioms)) continue;
                    eq = true;
                }
                for (Term t1$prime$prime : s1) {
                    for (Term t2$prime$prime : s2) {
                        if (eq || !t1$prime$prime.equalsUpTo(t2$prime$prime, axioms)) continue;
                        eq = true;
                    }
                }
                if (eq) continue;
                return false;
            }
        }
        return true;
    }

    public static class Coinduction<T extends Term<T>>
    implements Predicate<T> {
        private final Set<T> done = new HashSet<T>();
        private final BiPredicate<T, Set<T>> p;
        private final boolean debug;

        public Coinduction(BiPredicate<T, Set<T>> p) {
            this.p = p;
            this.debug = false;
        }

        public Coinduction(BiPredicate<T, Set<T>> p, boolean debug) {
            this.p = p;
            this.debug = debug;
        }

        @Override
        public boolean test(T t) {
            if (this.done.contains(t)) {
                return true;
            }
            this.done.add(t);
            LinkedHashSet successors = new LinkedHashSet();
            if (!this.p.test(t, successors)) {
                if (this.debug) {
                    System.err.println(t);
                }
                return false;
            }
            for (Term t$prime : successors) {
                if (this.test((T)t$prime)) continue;
                return false;
            }
            return true;
        }
    }
}

