/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mpstpp.terms.Act;
import mpstpp.terms.Axiom;
import mpstpp.terms.Mu;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.Term;

public abstract class Var<T extends Term<T>>
implements Term<T> {
    public final String vName;

    public Var(String vName) {
        this.vName = vName;
    }

    @Override
    public T alphaConvert() {
        return this.cast();
    }

    @Override
    public T bind(Map<String, T> spec) {
        return (T)(spec.containsKey(this.vName) ? (Term)spec.get(this.vName) : this.cast());
    }

    @Override
    public boolean canTerminate() {
        return false;
    }

    @Override
    public T eliminateTaus() {
        return this.cast();
    }

    @Override
    public boolean endsWith(String vName) {
        return this.vName.equals(vName);
    }

    @Override
    public Set<Act<T>> getActs() {
        return Collections.emptySet();
    }

    @Override
    public Set<T> getEqualsUpTo(List<Axiom> axioms) {
        LinkedHashSet s = new LinkedHashSet();
        s.add(this.cast());
        return s;
    }

    @Override
    public Set<T> getFreeVars() {
        HashSet s = new HashSet();
        s.add(this.cast());
        return s;
    }

    @Override
    public Set<Mu<T>> getMus() {
        return Collections.emptySet();
    }

    @Override
    public Set<Reduction<T>> getReductions() {
        return Collections.emptySet();
    }

    @Override
    public Set<Role> getRoles() {
        return Collections.emptySet();
    }

    @Override
    public List<T> getSubterms() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getVarNames() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.add(this.vName);
        return s;
    }

    @Override
    public boolean hasNoOccurrencesOfOne() {
        return true;
    }

    @Override
    public boolean hasNoOccurrencesOfTau() {
        return true;
    }

    @Override
    public boolean hasOnlyAsyncOccurrencesOf(Act a) {
        return true;
    }

    @Override
    public boolean hasOnlyOccurrencesOfTau() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public T simplify() {
        return this.cast();
    }

    @Override
    public String toMCRL2(String procPrefix) {
        return procPrefix + "_" + this.vName;
    }

    @Override
    public T unfold() {
        return this.cast();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Var var = (Var)o;
        return Objects.equals(this.vName, var.vName);
    }

    public int hashCode() {
        return Objects.hash(this.vName);
    }

    public String toString() {
        return this.vName;
    }
}

