/*
 * Decompiled with CFR 0.152.
 */
package mpstpp.terms.glob.act;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import mpstpp.terms.Act;
import mpstpp.terms.Reduction;
import mpstpp.terms.Role;
import mpstpp.terms.glob.Glob;
import mpstpp.terms.glob.One;
import mpstpp.terms.loc.Loc;
import mpstpp.terms.loc.act.Epsi;
import mpstpp.terms.loc.act.Recv;
import mpstpp.terms.loc.act.Send;

public class Comm
extends Act<Glob>
implements Glob {
    public final Role p;
    public final Role q;
    public final String l;
    public final String y;

    public Comm(Role p, Role q, String l, String y) {
        this.p = p;
        this.q = q;
        this.l = l;
        this.y = y;
    }

    @Override
    public Loc project(Role r) {
        if (this.p.equals(r) && !this.q.equals(r)) {
            return new Send(this.p, this.q, this.l, this.y);
        }
        if (!this.p.equals(r) && this.q.equals(r)) {
            return new Recv(this.p, this.q, this.l, this.y);
        }
        if (!this.p.equals(r) && !this.q.equals(r)) {
            return new Epsi(this.p, this.q);
        }
        throw new IllegalStateException();
    }

    @Override
    public Glob cast() {
        return this;
    }

    @Override
    public Set<Reduction<Glob>> getReductions() {
        LinkedHashSet<Reduction<Glob>> s = new LinkedHashSet<Reduction<Glob>>();
        Comm t = this;
        Comm a = this;
        One t$prime = new One();
        Reduction<One> r = new Reduction<One>((One)((Object)t), a, t$prime);
        s.add(r);
        return s;
    }

    @Override
    public Set<Role> getRoles() {
        HashSet<Role> s = new HashSet<Role>();
        s.add(this.p);
        s.add(this.q);
        return s;
    }

    @Override
    public String toMCRL2(String procPrefix) {
        return "comm_" + this.p + "_" + this.q + "_" + this.l + "_" + this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comm comm = (Comm)o;
        return Objects.equals(this.p, comm.p) && Objects.equals(this.q, comm.q) && Objects.equals(this.l, comm.l) && Objects.equals(this.y, comm.y);
    }

    public int hashCode() {
        return Objects.hash(this.p, this.q, this.l, this.y);
    }

    public String toString() {
        String s = this.p + "->" + this.q;
        if (!this.l.isEmpty()) {
            s = s + ":" + this.l;
            if (!this.y.isEmpty()) {
                s = s + "(" + this.y + ")";
            }
        }
        return s;
    }
}

